\name{DataExample}
\alias{DataExample}
\docType{data}
\title{
The data extracted from a meta-analysis by Cabibbo et al.
}
\description{
Data were extracted from the studies included in the meta-analysis by Cabibbo et al. which aimed to assess the survival rate in untreated patients with hepatocellular carcinoma.
}
\usage{data(DataExample)}
\format{
A data frame with with the 8 following variables (columns).
  \describe{
    \item{\code{Study}}{This numeric vector represents number of the study.}
	\item{\code{FirstAuthor}}{This vector represents the name of the first author.}
    \item{\code{YearPub}}{This numeric vector represents the publication year.}
    \item{\code{Time}}{This numeric vector represents the times for which the survival rates are collected in years.}
    \item{\code{Survival}}{This numeric vector represents the survival rates for each value of \code{Time}}
    \item{\code{NbRisk}}{This numeric vector represents the number of at-risk patients for each value of \code{Time}}
    \item{\code{Location}}{This factor indicates the location of the study (Asia, North Amercia or Europe)}
    \item{\code{Design}}{This factor indicates if the study is monocentric ou multicentric.}
  }
}
\details{
The survival probabilities were extracted from the published survival curves each month during the first six months and then by step of three months. The pictures of the curves were digitalized using the R package ReadImage and the probabilities were extracted using the package digitize proposed by Poisot. The numbers of at-risk patients for each interval of time were derived from the numbers of at-risk patients reported in the studies, and using the methods of Parmar or Williamson to account for censorship. Studies have different length of follow-up. For each study, survival probabilities and the numbers of at-risk patients were collected at all points in time before the end of follow-up.
}
\references{
Combescure C., Foucher Y. and Jackson D. The multivariate DerSimonian and Laird's methodology applied to meta-analysis of survival curves. Manuscript submitted.

Cabibbo, G., et al., A meta-analysis of survival rates of untreated patients in randomized clinical trials of hepatocellular carcinoma. Hepatology, 2010. 51(4): p. 1274-83.

Poisot, T., The digitize Package: Extracting Numerical Data from Scatter-plots. The R Journal, 2011. 3(1): p. 25-26.

Parmar, M.K., V. Torri, and L. Stewart, Extracting summary statistics to perform meta-analyses of the published literature for survival endpoints. Stat Med, 1998. 17(24): p. 2815-34

Williamson, P.R., et al., Aggregate data meta-analysis with time-to-event outcomes. Stat Med, 2002. 21(22): p. 3337-51.
}
\examples{

data(DataExample)
Times <- DataExample$Time
Survival <- DataExample$Survival
Study  <- DataExample$Study

plot(Times, Survival, type="n", 
 ylim=c(0,1), xlab="Time",ylab="Survival")

for (i in unique(sort(Study)))
{
lines(Times[Study==i], Survival[Study==i], type="l", col="grey")
points(max(Times[Study==i]),
 Survival[Study==i & Times == max( Times[Study==i])], pch=15)
}
}

\keyword{datasets}

